//Scripted by Jumpnjahosofat
//This file is part of the Urshaabi Gauntlet System
//I do not take complete credit for all of the files.  Many are modified RunUO scripts.
//This system is intended for drop in purposes so that it's easy for everyone to enjoy it.
//If you encounter problems, please leave me a message on the forum or my email - uo_cecil@yahoo.com
//Enjoy!!

using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "the corpse of Tombspirit" )]
	public class Tombspirit : BaseCreature
	{
		[Constructable]
		public Tombspirit() : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "Tombspirit";
			Title = "the Haunter";
			Body = 154;
			BaseSoundID = 471;

			SetStr( 301, 350 );
			SetDex( 75 );
			SetInt( 151, 200 );

			SetHits( 2000 );
			SetStam( 150 );
			SetMana( 200 );

			SetDamage( 10, 13 );

			SetDamageType( ResistanceType.Physical, 0 );
			SetDamageType( ResistanceType.Cold, 50 );
			SetDamageType( ResistanceType.Poison, 50 );

			SetResistance( ResistanceType.Physical, 35, 45 );
			SetResistance( ResistanceType.Fire, 60, 30 );
			SetResistance( ResistanceType.Cold, 50, 70 );
			SetResistance( ResistanceType.Poison, 40, 50 );
			SetResistance( ResistanceType.Energy, 60, 30 );

			SetSkill( SkillName.Poisoning, 120.0 );
			SetSkill( SkillName.MagicResist, 250.0 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 90.1, 100.0 );
			SetSkill( SkillName.Magery, 100.0, 120.0);
			SetSkill( SkillName.EvalInt, 100.0, 120.0);
			SetSkill( SkillName.Meditation, 100.0, 120.0);

			Fame = 6000;
			Karma = -6000;

			VirtualArmor = 50;
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
		}
		
		public override bool OnBeforeDeath()
		{
			StarRoomGate gate = new StarRoomGate( true );
			gate.Name = "Gauntlet of Horrors Level 2";
			gate.Target = new Point3D( 5276, 1173, 0 );
			gate.TargetMap = this.Map;
			gate.Hue = 34;
			gate.MoveToWorld( new Point3D( 5276, 1163, 0 ), this.Map );
			
			return base.OnBeforeDeath();
		}
		
		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
    		AOS.Damage( from, this, damage, 100, 0, 0, 0, 0 );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Lethal; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public Tombspirit( Serial serial ) : base( serial )
		{
		}

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}